﻿Imports jp.co.systembase.report
Imports jp.co.systembase.report.component
Imports jp.co.systembase.report.textformatter
Imports jp.co.systembase.report.renderer
Imports jp.co.systembase.report.renderer.gdi
Imports jp.co.systembase.report.renderer.gdi.elementrenderer

' 回転機能を加えたFieldレンダラ
Public Class GdiFieldRenderer
    Implements IElementRenderer

    Public Sub Render( _
      ByVal env As RenderingEnv, _
      ByVal reportDesign As ReportDesign, _
      ByVal region As Region, _
      ByVal design As ElementDesign, _
      ByVal data As Object) Implements IElementRenderer.Render
        If Not design.IsNull("rect") Then
            env.Setting.GetElementRenderer("rect").Render( _
                env, _
                reportDesign, _
                region, _
                design.Child("rect"), _
                Nothing)
        End If
        Dim text As String
        If env.InDesigner Then
            If Not design.IsNull("mock") Then
                Dim mockData As Object = GdiRenderUtil.GetMockData(design.Get("mock"))
                text = RenderUtil.Format(reportDesign, design.Child("formatter"), mockData)
            Else
                text = design.Get("exp")
                design.Put("decimal_place", 0)
            End If
        Else
            text = RenderUtil.Format(reportDesign, design.Child("formatter"), data)
        End If
        If text Is Nothing Then
            Exit Sub
        End If

        Dim _region As Region = region.ToPointScale(reportDesign)
        Dim __region As Region = _region
        Dim t As Drawing.Drawing2D.Matrix = env.Graphics.Transform

        ' テキストを回転させるための変換行列を設定します
        If Not design.IsNull("rotate") Then
            env.Graphics.TranslateTransform(_region.Left, _region.Top)
            env.Graphics.RotateTransform(design.Get("rotate"))
            __region = New Region
            __region.Right = _region.GetWidth
            __region.Bottom = _region.GetHeight
        End If

        ' テキストを描画します
        GdiRenderUtil.DrawText( _
          env.Graphics, _
          __region, _
          env.Setting, _
          New TextDesign(reportDesign, design), _
          text)

        ' 変換行列を復元します
        If Not design.IsNull("rotate") Then
            env.Graphics.Transform = t
        End If
    End Sub

End Class