﻿Imports jp.co.systembase.report
Imports jp.co.systembase.report.component
Imports jp.co.systembase.report.renderer.pdf

Public Class PdfFieldRenderer
    Inherits jp.co.systembase.report.renderer.pdf.elementrenderer.FieldRenderer

    Protected Overrides Function _GetPdfText(renderer As PdfRenderer, reportDesign As ReportDesign, region As Region, design As ElementDesign, text As String) As PdfText
        Dim ret = MyBase._GetPdfText(renderer, reportDesign, region, design, text)
        If Not design.IsNull("rotate") Then
            Dim r = -Math.PI * design.Get("rotate") / 180
            ret.TextMatrix = New List(Of Single)({Math.Cos(r), Math.Sin(r), -Math.Sin(r), Math.Cos(r)})
        End If
        Return ret
    End Function

End Class