﻿Imports jp.co.systembase.report
Imports jp.co.systembase.report.component
Imports jp.co.systembase.report.renderer.pdf
Imports Org.BouncyCastle.Utilities

Class PdfRotatableText
    Inherits PdfText

    Public Overrides Sub Initialize(renderer As PdfRenderer, reportDesign As ReportDesign, region As Region, design As ElementDesign, text As String)
        MyBase.Initialize(renderer, reportDesign, region, design, text)
        Dim _region = region
        Dim matrix As List(Of Single) = Nothing
        Select Case design.Get("vertical_rotate")
            Case "top_to_bottom"
                matrix = _RotateMatrix(90)
                _region = New Region()
                _region.Top = region.Top - TextDesign.Font.Size + 4.0
                _region.Left = region.Right - TextDesign.Font.Size - 0.5
                _region.SetHeight(region.GetWidth)
                _region.SetWidth(region.GetHeight)
            Case "bottom_to_top"
                matrix = _RotateMatrix(270)
                _region = New Region()
                _region.Top = region.Bottom - TextDesign.Font.Size - 0.5
                _region.Left = region.Left + TextDesign.Font.Size - 2.0
                _region.SetHeight(region.GetWidth)
                _region.SetWidth(region.GetHeight)
        End Select
        Me.Region = _region
        Me.TextMatrix = matrix
    End Sub

    Private Function _RotateMatrix(d As Single) As List(Of Single)
        Dim _d = -Math.PI * d / 180.0
        Return New List(Of Single)({Math.Cos(_d), Math.Sin(_d), -Math.Sin(_d), Math.Cos(_d)})
    End Function

End Class
