﻿Imports jp.co.systembase.report
Imports jp.co.systembase.report.component
Imports jp.co.systembase.report.renderer.gdi
Imports System.Drawing

Class GdiRotatableText
    Inherits GdiText
    Private _Rotate As Single = 0
    Private _RotatePos As Point = Nothing
    Public Overrides Sub Initialize(env As RenderingEnv, reportDesign As ReportDesign, region As component.Region, design As ElementDesign, text As String)
        Dim _region = region
        Select Case design.Get("vertical_rotate")
            Case "top_to_bottom"
                _Rotate = 90
                _region = New component.Region()
                _region.Right = region.GetHeight
                _region.Bottom = region.GetWidth
                _RotatePos = New Point(region.Right, region.Top)
            Case "bottom_to_top"
                _Rotate = 270
                _region = New component.Region()
                _region.Right = region.GetHeight
                _region.Bottom = region.GetWidth
                _RotatePos = New Point(region.Left, region.Bottom)
        End Select
        MyBase.Initialize(env, reportDesign, _region, design, text)
    End Sub
    Public Overrides Sub Draw()
        Dim t = Graphics.Transform
        If _Rotate Then
            Graphics.TranslateTransform(_RotatePos.X, _RotatePos.Y)
            Graphics.RotateTransform(_Rotate)
        End If
        MyBase.Draw()
        Graphics.Transform = t
    End Sub
End Class
