﻿Imports jp.co.systembase.report.renderer.gdi
Imports jp.co.systembase.report.renderer.pdf
Imports jp.co.systembase.rotatable

Module RendererSetting

    Private _GdiSetting As GdiRendererSetting = Nothing
    Private _PdfSetting As PdfRendererSetting = Nothing

    Public Function GetGdiSetting() As GdiRendererSetting
        If _GdiSetting Is Nothing Then
            _GdiSetting = New GdiRendererSetting
            _GdiSetting.ElementRendererMap("field") = New GdiFieldRenderer
            _GdiSetting.ElementRendererMap("text") = New GdiTextRenderer
            _GdiSetting.ElementRendererMap("barcode") = New GdiBarcodeRenderer
        End If
        Return _GdiSetting
    End Function

    Public Function GetPdfSetting() As PdfRendererSetting
        If _PdfSetting Is Nothing Then
            _PdfSetting = New PdfRendererSetting
            _PdfSetting.ElementRendererMap("field") = New PdfFieldRenderer
            _PdfSetting.ElementRendererMap("text") = New PdfTextRenderer
            _PdfSetting.ElementRendererMap("barcode") = New PdfBarcodeRenderer
        End If
        Return _PdfSetting
    End Function

End Module
