﻿Imports System.IO
Imports jp.co.systembase.json
Imports jp.co.systembase.report
Imports jp.co.systembase.report.data
Imports jp.co.systembase.report.renderer.gdi
Imports jp.co.systembase.report.renderer.pdf

Module Main

    Public Sub main()
        Dim report As New Report(Json.Read("report\example.rrpt"))
        report.Fill(DummyDataSource.GetInstance)
        Dim pages As ReportPages = report.GetPages()

        ' プレビュー
        With Nothing
            Dim printer As New Printer(pages, RendererSetting.GetGdiSetting())
            Dim preview As New FmPrintPreview(printer)
            preview.ShowDialog()
        End With

        ' PDF出力
        Using fs As New FileStream("output.pdf", IO.FileMode.Create)
            Dim renderer As New PdfRenderer(fs, RendererSetting.GetPdfSetting())
            pages.Render(renderer)
        End Using
        ' PDFファイルを開きます
        System.Diagnostics.Process.Start("output.pdf")
    End Sub

End Module
