Imports Newtonsoft.Json
Imports System.IO

Public Module Json

    Public Function Read(path As String) As Hashtable
        Using reader As New StreamReader(path)
            Return Read(reader)
        End Using
    End Function

    Public Function Read(reader As TextReader) As Hashtable
        Return Read(New JsonTextReader(reader))
    End Function

    Public Function Read(reader As JsonReader) As Hashtable
        If reader.Read Then
            Return readHash(reader)
        Else
            Return Nothing
        End If
    End Function

    Private Function readNode(reader As JsonReader) As Object
        Select Case reader.TokenType
            Case JsonToken.StartArray
                Return readArray(reader)
            Case JsonToken.StartObject
                Return readHash(reader)
            Case Else
                Return reader.Value
        End Select
    End Function

    Private Function readArray(reader As JsonReader) As ArrayList
        Dim ret As New ArrayList
        Do While reader.Read
            If reader.TokenType = JsonToken.EndArray Then
                Return ret
            End If
            ret.Add(readNode(reader))
        Loop
        Return ret
    End Function

    Private Function readHash(reader As JsonReader) As Hashtable
        Dim ret As New Hashtable
        Do While reader.Read
            Dim key As Object = Nothing
            If reader.TokenType = JsonToken.EndObject Then
                Return ret
            End If
            If reader.TokenType = JsonToken.PropertyName Then
                key = reader.Value
                reader.Read()
            End If
            ret.Add(key, readNode(reader))
        Loop
        Return ret
    End Function

End Module