﻿using Newtonsoft.Json;
using System.Collections;
using System.IO;

public class Json
{

    public static Hashtable Read(string path)
    {
        using (var reader = new StreamReader(path))
        {
            return Read(reader);
        }
    }

    public static Hashtable Read(TextReader reader)
    {
        return Read(new JsonTextReader(reader));
    }

    public static Hashtable Read(JsonReader reader)
    {
        if (reader.Read())
        {
            return readHash(reader);
        }
        else
        {
            return null;
        }
    }

    private static object readNode(JsonReader reader)
    {
        switch (reader.TokenType)
        {
            case JsonToken.StartArray:
                return readArray(reader);
            case JsonToken.StartObject:
                return readHash(reader);
            default:
                return reader.Value;
        }
    }

    private static ArrayList readArray(JsonReader reader)
    {
        var ret = new ArrayList();
        while (reader.Read())
        {
            if (reader.TokenType == JsonToken.EndArray)
            {
                return ret;
            }
            ret.Add(readNode(reader));
        }
        return ret;
    }

    private static Hashtable readHash(JsonReader reader)
    {
        var ret = new Hashtable();
        while (reader.Read())
        {
            object key = null;
            if (reader.TokenType == JsonToken.EndObject)
            {
                return ret;
            }
            if (reader.TokenType == JsonToken.PropertyName)
            {
                key = reader.Value;
                reader.Read();
            }
            ret.Add(key, readNode(reader));
        }
        return ret;
    }

}