package example;

import java.io.FileOutputStream;

import jp.co.systembase.core.DataTable;
import jp.co.systembase.report.Report;
import jp.co.systembase.report.ReportPages;
import jp.co.systembase.report.ReportSetting;
import jp.co.systembase.report.component.ElementDesign;
import jp.co.systembase.report.data.ReportDataSource;
import jp.co.systembase.report.renderer.pdf.PdfRenderer;
import jp.co.systembase.report.textformatter.ITextFormatter;

// 機能サンプル カスタム書式/要素
public class ExampleExtention2 {

	public static void main(String[] args) throws Exception {
		ReportSetting setting = new ReportSetting();
		setting.textFormatterMap.put("priceFormat", new PriceFormatUtil());

		Report report = new Report(ReadUtil.readJson("report/example_extention.rrpt"), setting);
		report.fill(new ReportDataSource(getDataTable()));
		ReportPages pages = report.getPages();

		// PDF出力
		{
			FileOutputStream fos = new FileOutputStream("output/example_extention.pdf");
			try {
				PdfRenderer renderer = new PdfRenderer(fos);
				pages.render(renderer);
			} finally {
				fos.close();
			}
		}
	}

	private static DataTable getDataTable() throws Exception {
		DataTable ret = new DataTable();
		ret.setFieldNames("v");
		ret.addRecord().puts(1000);
		ret.addRecord().puts(2000);
		ret.addRecord().puts(3333);
		ret.addRecord().puts(400);
		return ret;
	}

	public static class PriceFormatUtil implements ITextFormatter
	{
	    public String format(Object v, ElementDesign design)
	    {
	    	if (v == null)
	    	{
	    		return null;
	    	}

	    	String formatValue = v.toString()+"AAAAAAA";
	    	System.out.println(formatValue);
	    	return formatValue;
	    }
	}

}
