﻿Imports System.Drawing
Imports jp.co.systembase.report.renderer.gdi

Public Class GdiTextEx
    Inherits GdiText

    Public Overrides Sub Initialize( _
      env As renderer.gdi.RenderingEnv, _
      reportDesign As ReportDesign, _
      region As component.Region, _
      design As component.ElementDesign, _
      text As String)
        Dim _region As New component.Region
        Dim padding As Single = design.Get("padding")
        _region.Top = region.Top + padding
        _region.Left = region.Left + padding
        _region.Right = region.Right - padding
        _region.Bottom = region.Bottom - padding
        MyBase.Initialize(env, reportDesign, _region, design, text)
    End Sub

    Protected Overrides Function _GetStringFormat() As StringFormat
        Dim sf As New StringFormat(StringFormat.GenericTypographic)
        Dim sf0 As New StringFormat()
        sf.FormatFlags = sf0.FormatFlags
        sf.Trimming = sf0.Trimming
        Return sf
    End Function

End Class
