﻿Imports jp.co.systembase.json
Imports jp.co.systembase.report
Imports jp.co.systembase.report.data
Imports jp.co.systembase.report.renderer.gdi
Imports jp.co.systembase.report.extension

Public Module Main

    Public Sub main()
        Dim report As New Report(Json.Read("example.rrpt"))
        report.Fill(DummyDataSource.GetInstance)
        Dim pages As ReportPages = report.GetPages()

        ' Settingオブジェクトを渡してprinterオブジェクトを生成します
        Dim printer As New Printer(pages, GetGdiRendererSetting)
        Dim preview As New FmPrintPreview(printer)
        preview.ShowDialog()
    End Sub

    ' GDIレンダラ設定オブジェクトを返します
    Private _GdiRendererSetting As GdiRendererSetting = Nothing
    Public Function GetGdiRendererSetting() As GdiRendererSetting
        If _GdiRendererSetting Is Nothing Then
            ' field/textレンダラを設定します
            _GdiRendererSetting = New GdiRendererSetting
            _GdiRendererSetting.ElementRendererMap("field") = New FieldRendererEx
            _GdiRendererSetting.ElementRendererMap("text") = New TextRendererEx
        End If
        Return _GdiRendererSetting
    End Function

End Module
